<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contrats extends Model 
{

    protected $table = 'contrats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function professeurs()
    {
        return $this->belongsToMany('App\Models\Professeur');
    }

    public function salaires()
    {
        return $this->hasMany('App\Models\FacturesProfesseurs');
    }

    public function matieres()
    {
        return $this->hasMany('App\Models\Matiere');
    }

}